/**************************************************************************************

   Copyright (c) Hilscher GmbH. All Rights Reserved.

 **************************************************************************************

   Filename:
    $Workfile: CcLinkAps_Public.h $
   Last Modification:
    $Id: CcLinkAps_Public.h 15663 2011-03-17 15:11:45Z Eric $

    $Author: Eric $
    $Modtime: 11.09.08 8:27 $
    $Revision: 11 $

   Targets:
    Win32/ANSI   : no
    Win32/Unicode: no (define _UNICODE)
    WinCE        : yes
    rcX          : yes

   Description:

    CcLink Aps
    public

   Changes:

     Version    Date        Author
        Description
     ----------------------------------------------------------------------------------
     14         10.03.11    ES
         Configurarion flags for baud and address switches

     13         02.03.10    ES
        Added data loop request

     12         14.01.10    ES
        Added parameter for I/O points and types

     11         20.08.08    ES
        Removed unused structures
        Added configuration request

     7          19.11.07    ES
        Removed model code parameter

     4          06.11.07    ES
        Corrected definition for warmstart configuration packet

     3          06.11.07    ES
        Changed rotary switch configuration address from 0 to 255

     2          31.10.07    ES
        Created

**************************************************************************************/
/**
 * @file CcLinkAps_Public.h
 *  CcLink Aps - public definition of task
 *
 * The header contains the public definition of task.
 * It has to be included by another task to get access of task specfic definition.
 *
 * @note
 * The structures for the services must be packed on 1 byte of boundary.
 * The <code>#pragma</code> instructions are already planned for Microsoft compiler.
 * For gnu's compiler and Realview compiler the macros <code>__PACKED_PRE</code>
 * and <code>__PACKED_PRE</code> have to be added with the structural definition
 * in addition.
 */
#ifndef __CCLINK_APS_PUBLIC_H
#define __CCLINK_APS_PUBLIC_H

#define CCLINK_APS_WARMSTART_REQ          0x00004600L
#define CCLINK_APS_WARMSTART_CNF          0x00004601L

#define CCLINK_APS_GET_STATE_REQ          0x00004602L
#define CCLINK_APS_GET_STATE_CNF          0x00004603L

#define CCLINK_APS_SET_CONFIGURATION_REQ  0x00004604L
#define CCLINK_APS_SET_CONFIGURATION_CNF  0x00004605L

#define CCLINK_APS_SET_DATA_LOOP_REQ      0x000046E0L
#define CCLINK_APS_SET_DATA_LOOP_CNF      0x000046E1L

/*************************************************************************************/
/** @name Queue Name
 *
 * Use the queue name to identify the process queue of task 'CcLink Aps'.
 * Example for internal identification:<br>
 * @code
 * TLR_RESULT eRslt;
 * TLR_HANDLE hQue;
 * TLR_UINT   uiInstance = 0;
 *
 * eRslt = TLR_QUE_IDENTIFY_INTERN(
 *                                 CCLINK_APS_QUEUE_NAME,
 *                                 uiInstance,
 *                                 &hQue
 *                                );
 * @endcode
 * <br>
 * Example for external or normal identification:<br>
 * @code
 * TLR_RESULT      eRslt;
 * TLR_QUE_LINK_T  tQue;
 * TLR_UINT        uiInstance = 0;
 *
 * eRslt = TLR_QUE_IDENTIFY(CCLINK_APS_QUEUE_NAME, uiInstance, &tQue);
 * @endcode
 * <br>
 * @{
 */
/** queue name */
#define CCLINK_APS_QUEUE_NAME        "QUE_CCLAPS"

/** @} */

/*************************************************************************************/
/* definitions */

#define CCLINK_APS_SYS_FLAG_COM_CONTROLLED_RELEASE   0x00000001L
#define CCLINK_APS_SYS_FLAG_IO_STATUS_ENABLED        0x00000002L
#define CCLINK_APS_SYS_FLAG_IO_STATUS_32_BIT         0x00000004L

#define CCLINK_APS_SYS_FLAG_ADDRESS_SWITCH           0x00000010L /* Switch for address */
#define CCLINK_APS_SYS_FLAG_BAUD_SWITCH              0x00000020L /* Switch for baud    */

#define CCLINK_APS_WD_OFF                            0x00000000L
#define CCLINK_APS_WD_MIN_TIMEOUT                    0x00000014L
#define CCLINK_APS_WD_MAX_TIMEOUT                    0x0000FFFFL

#define CCLINK_APS_CCLS_FLAGS_CFG_VENDOR_CODE        0x00000001L
#define CCLINK_APS_CCLS_FLAGS_CFG_MODEL_TYPE         0x00000002L
#define CCLINK_APS_CCLS_FLAGS_CFG_SW_VERSION         0x00000004L

#define CCLINK_APS_STATION_ADDR_CFG_ROTARY_SWITCH    0x000000FFL


/*************************************************************************************/
/* packets */

/* pragma pack */
#ifdef PRAGMA_PACK_ENABLE
#pragma PRAGMA_PACK_1(__CCLINK_APS_PACKET)
#endif


/** @name Packet Data Definition
 *
 * The following defined structures represent the specific parameter
 * of the several services, which are supported by the task.
 * @{
 */

/*************************************************************************************/
/** type of <code>CCLINK_APS_GET_STATE_CNF_DATA_Ttag</code> */
typedef struct CCLINK_APS_GET_STATE_CNF_DATA_Ttag
  CCLINK_APS_GET_STATE_CNF_DATA_T;

__PACKED_PRE struct CCLINK_APS_GET_STATE_CNF_DATA_Ttag
{
  TLR_UINT32 ulReserved;

}__PACKED_POST;
/*************************************************************************************/

/*************************************************************************************/
/** type of <code>CCLINK_APS_WARMSTART_REQ_DATA_Ttag</code> */
typedef struct CCLINK_APS_WARMSTART_REQ_DATA_Ttag
  CCLINK_APS_WARMSTART_REQ_DATA_T;
/** type of <code>CCLINK_APS_WARMSTART_CNF_DATA_Ttag</code> */
typedef struct CCLINK_APS_WARMSTART_CNF_DATA_Ttag
  CCLINK_APS_WARMSTART_CNF_DATA_T;

__PACKED_PRE struct CCLINK_APS_WARMSTART_REQ_DATA_Ttag
{
  TLR_UINT32    ulSystemFlags;      /* System flags   */
  TLR_UINT32    ulCcLinkFlags;      /* CC-Link Flags  */

  TLR_UINT32    ulWdgTime;          /* Watchdog time  */

  TLR_UINT32    ulSlaveStationAddr; /* Node ID        */
  TLR_UINT32    ulBaudRate;         /* BaudRate       */

  TLR_UINT32    ulStationType;

  TLR_UINT32    ulNoStation;

  TLR_UINT32    ulCcLinkVersion;
  TLR_UINT32    ulExtensionCycle;

  TLR_UINT32    ulReserved;
  TLR_BOOLEAN32 fHoldClrMode;

  TLR_UINT32    ulVendorCode;
  TLR_UINT32    ulModelType;
  TLR_UINT32    ulSwVersion;

} __PACKED_POST;

__PACKED_PRE struct CCLINK_APS_WARMSTART_CNF_DATA_Ttag
{
  TLR_UINT32    ulSystemFlags;      /* System flags   */
  TLR_UINT32    ulCcLinkFlags;      /* CC-Link Flags  */

  TLR_UINT32    ulWdgTime;          /* Watchdog time  */

  TLR_UINT32    ulSlaveStationAddr; /* Node ID        */
  TLR_UINT32    ulBaudRate;         /* BaudRate       */

  TLR_UINT32    ulStationType;

  TLR_UINT32    ulNoStation;

  TLR_UINT32    ulCcLinkVersion;
  TLR_UINT32    ulExtensionCycle;

  TLR_UINT32    ulReserved;
  TLR_BOOLEAN32 fHoldClrMode;

  TLR_UINT32    ulVendorCode;
  TLR_UINT32    ulModelType;
  TLR_UINT32    ulSwVersion;

} __PACKED_POST;
/*************************************************************************************/

/*************************************************************************************/
/** type of <code>CCLINK_APS_SET_CONFIGURATION_REQ_DATA_Ttag</code> */
typedef struct CCLINK_APS_SET_CONFIGURATION_REQ_DATA_Ttag
  CCLINK_APS_SET_CONFIGURATION_REQ_DATA_T;

__PACKED_PRE struct CCLINK_APS_SET_CONFIGURATION_REQ_DATA_Ttag
{
  TLR_UINT32    ulSystemFlags;      /* System flags         */
  TLR_UINT32    ulWdgTime;          /* Watchdog time        */

  TLR_UINT32    ulCcLinkFlags;      /* CC-Link Flags        */

  TLR_UINT32    ulSlaveStationAddr; /* Node ID              */
  TLR_UINT32    ulBaudRate;         /* BaudRate             */

  TLR_UINT32    ulStationType;      /* Station type         */

  TLR_UINT32    ulNoStation;        /* Number of stations   */

  TLR_UINT32    ulCcLinkVersion;    /* CC-Link version      */
  TLR_UINT32    ulExtensionCycle;   /* Number of cycles     */

  TLR_UINT32    ulIoTypesPoints;    /* I/O types and points */
  TLR_BOOLEAN32 fHoldClrMode;       /* Hold/Clear           */

  TLR_UINT32    ulVendorCode;       /* Vendor code          */
  TLR_UINT32    ulModelType;        /* Model type           */
  TLR_UINT32    ulSwVersion;        /* Software version     */

} __PACKED_POST;
/*************************************************************************************/

/*************************************************************************************/
/** type of <code>CCLINK_APS_SET_DATA_LOOP_REQ_DATA_Ttag</code> */
typedef struct CCLINK_APS_SET_DATA_LOOP_REQ_DATA_Ttag
  CCLINK_APS_SET_DATA_LOOP_REQ_DATA_T;

#define CCLINK_APS_DATA_LOOP_DISABLE  0x00000000L
#define CCLINK_APS_DATA_LOOP_ENABLE   0x00000001L

__PACKED_PRE struct CCLINK_APS_SET_DATA_LOOP_REQ_DATA_Ttag
{
  TLR_UINT32 ulMode;

} __PACKED_POST;
/*************************************************************************************/


/** @} */


/** @name Packet Definition
 *
 * The following definied structures represent the packets of the several services,
 * which are supported by the task.
 * @{
 */

/*************************************************************************************/
/** type of <code>CCLINK_APS_PCK_GET_STATE_REQ_Ttag</code> */
typedef struct CCLINK_APS_PCK_GET_STATE_REQ_Ttag
  CCLINK_APS_PCK_GET_STATE_REQ_T;
/** type of <code>CCLINK_APS_PCK_GET_STATE_CNF_Ttag</code> */
typedef struct CCLINK_APS_PCK_GET_STATE_CNF_Ttag
  CCLINK_APS_PCK_GET_STATE_CNF_T;

__PACKED_PRE struct CCLINK_APS_PCK_GET_STATE_REQ_Ttag
{
  TLR_PACKET_HEADER_T tHead;  /** packet header */

}__PACKED_POST;

__PACKED_PRE struct CCLINK_APS_PCK_GET_STATE_CNF_Ttag
{
  TLR_PACKET_HEADER_T              tHead;   /** packet header */
  CCLINK_APS_GET_STATE_CNF_DATA_T  tData;   /** packet data   */

}__PACKED_POST;
/*************************************************************************************/

/*************************************************************************************/
/** type of <code>CCLINK_APS_PCK_WARMSTART_REQ_Ttag</code> */
typedef struct CCLINK_APS_PCK_WARMSTART_REQ_Ttag
  CCLINK_APS_PCK_WARMSTART_REQ_T;
/** type of <code>CCLINK_APS_WARMSTART_CNF_Ttag</code> */
typedef struct CCLINK_APS_PCK_WARMSTART_CNF_Ttag
  CCLINK_APS_PCK_WARMSTART_CNF_T;

__PACKED_PRE struct CCLINK_APS_PCK_WARMSTART_REQ_Ttag
{
  TLR_PACKET_HEADER_T             tHead; /** packet header */
  CCLINK_APS_WARMSTART_REQ_DATA_T tData; /** packet data   */

} __PACKED_POST;

__PACKED_PRE struct CCLINK_APS_PCK_WARMSTART_CNF_Ttag
{
  TLR_PACKET_HEADER_T             tHead; /** packet header */
  CCLINK_APS_WARMSTART_CNF_DATA_T tData; /** packet data   */

}__PACKED_POST;
/*************************************************************************************/

/*************************************************************************************/
/** type of <code>CCLINK_APS_SET_CONFIGURATION_REQ_Ttag</code> */
typedef struct CCLINK_APS_SET_CONFIGURATION_REQ_Ttag
  CCLINK_APS_SET_CONFIGURATION_REQ_T;
/** type of <code>CCLINK_APS_SET_CONFIGURATION_CNF_Ttag</code> */
typedef struct CCLINK_APS_SET_CONFIGURATION_CNF_Ttag
  CCLINK_APS_SET_CONFIGURATION_CNF_T;

__PACKED_PRE struct CCLINK_APS_SET_CONFIGURATION_REQ_Ttag
{
  TLR_PACKET_HEADER_T                     tHead; /** packet header */
  CCLINK_APS_SET_CONFIGURATION_REQ_DATA_T tData; /** packet data   */

} __PACKED_POST;

__PACKED_PRE struct CCLINK_APS_SET_CONFIGURATION_CNF_Ttag
{
  TLR_PACKET_HEADER_T tHead; /** packet header */

}__PACKED_POST;
/*************************************************************************************/
/** type of <code>CCLINK_APS_SET_DATA_LOOP_REQ_Ttag</code> */
typedef struct CCLINK_APS_SET_DATA_LOOP_REQ_Ttag
  CCLINK_APS_SET_DATA_LOOP_REQ_T;
/** type of <code>CCLINK_APS_SET_DATA_LOOP_CNF_Ttag</code> */
typedef struct CCLINK_APS_SET_DATA_LOOP_CNF_Ttag
  CCLINK_APS_SET_DATA_LOOP_CNF_T;

__PACKED_PRE struct CCLINK_APS_SET_DATA_LOOP_REQ_Ttag
{
  TLR_PACKET_HEADER_T                 tHead; /** packet header */
  CCLINK_APS_SET_DATA_LOOP_REQ_DATA_T tData; /** packet data   */

} __PACKED_POST;

__PACKED_PRE struct CCLINK_APS_SET_DATA_LOOP_CNF_Ttag
{
  TLR_PACKET_HEADER_T tHead; /** packet header */

}__PACKED_POST;
/*************************************************************************************/


/** @} */

/* pragma unpack */
#ifdef PRAGMA_PACK_ENABLE
#pragma PRAGMA_UNPACK_1(__CCLINK_APS_PACKET)
#endif


/*************************************************************************************/
#endif /* #ifndef __CCLINK_APS_PUBLIC_H */

/*************************************************************************************/
/*-----------------------------------------------------------------------------------*/
/*-------------------------- EOF ----------------------------------------------------*/
/*-----------------------------------------------------------------------------------*/
/*************************************************************************************/

